;Z80 VERSION OF 2650 GRAPHICS PACKAGE
;TRANSLATED BY S. K. PHILLIPS  JAN. 1980.
;
	TITLE DG640 GRAPHICS FOR Z80
;
;
	ORG 100H
;
PAGE	EQU	0E8H	;VDU START LOCATION
;
	JP	START	;GO TO START
;
;EXTRACT OP CODE FROM I/P INFORMATION
;NB. I/P INFO. IN H&L 
;H=OP CODE + Y COORD.  L=X COORD.
;
GRAP:	LD	A,0C0H	;MASK WORD
	AND	H
	LD	(OPER),A	;SAVE OP CODE
;
;ENTER HERE TO BYPASS OP CODE
SADD:	LD	A,H
	LD	(Y),A	;SAVE Y ADDRESS
	LD	A,L
	LD	(X),A	;SAVE X ADDRESS
;
;EXTRACT ADDRESS OF BYTE CONTAINING THIS BIT
;
	RR	L
	RL	H
	RL	L
	RL	L
	RR	H
	RR	H
	RR	H
	RR	H
	RR	L
	RR	H
	RR	L
	LD	A,H
	AND	03H	;MASK TO GET 2 BITS OF POINTER
	OR	PAGE	;PAGE=VDU ADDRESS
	LD	(PTR+1),A	;SAVE HIGH ORDER
	LD	A,L
	LD	(PTR),A		;SAVE LOW ORDER
;
;SET UP INDEX TO BIT WITHIN THIS BYTE
;
	LD	L,01H
	LD	A,H
	AND	70H	;MASK TO GET INDEX
	JR	Z,ND-$
LOP:	RL	L
	SUB	10H	;THIS DECREMENTS THE INDEX BY 1
	JR	NZ,LOP-$
ND:	LD	A,L	;L NOW =8 BIT REPRESENTATION OF
			;3 BIT INDEX
	LD	(INDX),A	;STORE THE 8 BITS
;
;SET/CLEAR/INVERT/TEST BIT
;
MOP:	LD	HL,(PTR)	;HL POINTS TO BYTE ON SCREEN
	LD	B,(HL)	;GET CONTENTS OF BYTE ON SCREEN
	LD	A,(OPER)	;GET OPERAND
	AND	A	;SET FLAGS
	JR	Z,TEST-$	;JMP IF 00
	CP	80H	;SEE IF 'CLEAR' CODE
	LD	A,(INDX)	;GET IX BYTE
	JP	M,SET	;IF LT MUST BE SET=01B
	JR	Z,REST-$	;IF EQ MUST BE CLEAR=10B
	JP	P,INVT	;IF GT MUST BE INVERT=11B
REST:	AND	B	;RESET
INVT:	XOR	B	;INVERT
STORE:	LD	(HL),A	;STORE NEW CONTENTS
	RET
SET:	OR	B	;OR IN NEW BIT
	JR	STORE-$
TEST:	AND	B
	RET		;WILL RETURN WITH ZERO FLAG SET
			;IF TEST FOR BIT AT THIS POINT
			;SHOWS THERE WAS NOTHING
;
;GRAPHICS INITIALISATION ROUTINE
;
INIT:	LD	HL,0E800H	;VDU ADDRESS
LOOP1:	LD	(HL),00	;CLEAR SCREEN CODE
	INC	HL
	BIT	2,H	;DETECTS EC00 HEX
	JR	Z,LOOP1-$
LOOP2:	LD	(HL),02	;CODE FOR GRAPHICS
	INC	HL
	BIT	4,H	;DETECTS F000 HEX
	JR	Z,LOOP2-$
	LD	A,1
	LD	(INDX),A	;INIT INDEX
	LD	A,0
	LD	(X),A
	LD	(Y),A
	LD	(PTR),A	;INIT X, Y & PTR
	LD	A,0E8H
	LD	(PTR+1),A	;INIT MSB OF POINTER
;
;PICTURE WRITER ROUTINE
;ENTER HERE
;
START:	LD	SP,6000H
IN:	CALL	FIN	;FLASH AND GET CHARACT IN A
	CP	0EH	;SEE IF CTL-N
	JR	Z,INIT-$	;IF SO INIT GRAPHICS
;
;TEST IF END
;
	CP	0DH	;SEE IF CR
	JP	Z,0000	;WARM BOOT
	PUSH	AF	;SAVE A
	AND	07
	LD	E,A	;SAVE IN E LAST 3 BITS
			;E=DIRECTION NUMBER
	POP	AF	;RESTORE A
	AND	70H	;MASK TO GET SIGNIFICANT
			;ASCII DIGITS
;
;WORK OUT OP CODE
;
	CP	40H	;SEE IF PLAIN LETTER
	JR	NZ,W1-$
	LD	A,40H	;LOAD WRITE CODE=01B
	JR	SETBIT-$
W1:	JP	P,MOVE	;LOWER CASE LETTER
CLEAR:	LD	A,80H	;MUST HAVE BEEN CTL
			;THEREFORE CLEAR=10B
	JR	SETBIT-$
MOVE:	LD	A,00	;LOWER CASE THEREFORE MOVE
			; MOVE=00B
SETBIT:	LD	(OPER),A	;STORE NEW OPERAND
;
;PERFORM OPERATION
;
	CALL	MOP	;DO OP AT PRESENT LOCATION
;
;INCREMENT X COORDINATE
;
	LD	IX,DATA	;POINT TO DATA
	LD	D,00	;NB. DIRECTION NUM. IS IN REG E
	ADD IX,DE	;POINT TO APPROPRIATE PLACE IN TABLE
	LD	A,(X)	;GET X COORD.
	ADD	A,(IX)	;ADD ENTRY FROM TABLE
	LD	L,A	;SAVE IN L
;
;INCREMENT Y COORDINATE
;
	LD	A,(Y)	;GET Y COORD.
	INC	IX
	INC	IX	;POINT TO Y DATA
	SUB	(IX)	;SUB BECAUSE PAGE UPSIDE DOWN
	AND	3FH	;SET OP CODE TO 00
	LD	H,A	;SAVE IN H
;
;PERFORM OPERATION
;
	CALL	GRAP	;CURSOR MOVES TO NEW LOCATION
	JR	IN-$
;FLASH UNTIL INPUT
;
FIN:	LD	A,0C0H	;SET CODE FOR INVERT
	LD	(OPER),A
FLSH:	CALL	MOP	;DO IT
	LD	C,2	;DELAY CONSTANT
	CALL	DO	;DO DELAY
F0:	IN	A,(7DH)	;GET STATUS
	AND	02	;CHECK FOR RX BUFF READY
	JR	Z,F1-$	;JUMP IF NO I/P
	IN	A,(7CH)	;GET I/P
	AND	7FH	;MASK PARITY
	RET
F1:	CALL	MOP	;INVERT AGAIN
	LD	C,8H	;DELAY CONST.
	CALL	DO	;4 TIMES DELAY
	JR	FLSH-$
;
;DELAY
;
DO:	PUSH	BC
	PUSH	DE
D1:	LD	B,10H	;B,D LOOP GIVES .1 SECS.
D2:	LD	D,00
D3:	DEC	D
	JR	NZ,D3-$
	DEC	B
	JR	NZ,D2-$
	DEC	C
	JR	NZ,D1-$
	POP	DE
	POP	BC
	RET
;
;
DATA:	DEFB	0,1,1,1,0
	DEFB	0FFH,0FFH,0FFH,0,1
OPER:	DEFS	1
INDX:	DEFS	1
X:	DEFS	1
Y:	DEFS	1
PTR:	DEFS	2
;
;
END
F#h!Cs!^#V   ##::^#V#þ*^#V>%#x'8_ #*;#ø##>%><7"T6 *} ^!T42
G Ͱ	*hMͽG:ͮ+GGW	+GU!ͩ>̀+!   @ !!BH 	@ @A BH		 B! "BHI$$BI$BI $	HI	 D$